 // This is a skeletal Thor C++ application 

#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>


#include "common/th_assert.h"
#include "thor.h"
#include "th_string.h"
#include "th_Class.h"

#include "th_directory.h"


void main(int argc, char **argv)
{
    char const* exc;

    // Open connection with front-end
    th_init ();
    disable_futures();

    // Get the root of the initial OR.
    th_directory root_dir = th_get_root();

    if (th_catch_any(exc)) {
	fprintf(stderr, "Exception: %s\n", exc);
	exit(EXIT_FAILURE);
    }


   th_commit();
   if (!th_catch("abort"))
       cerr << "Transaction Committed\n";
   else
       cerr << "Transaction Aborted\n";

   cout << "Exiting\n";

   th_shutdown();
  }







