/* Copyright Barbara Liskov, MIT, 1996 */

#include "bcs.h"

#if BCS

/*=========================================================================
 *   Functions for control structures
 *=======================================================================*/

void th_cell_new(th_any *c)
{
// Batch a call to the fe initializing a new th_cell object.
  char ch;

  RETURN_VOID_IF_EXC();

  if (th_config->veneer_using_futures) {
    INCR_BY_SIZE(sizeof(int));
    SEND_MSG_SIZE();
    put_new_cell_futures(th_config->client_out);
  }
  else {
    SEND_MSG_SIZE();
    put_new_cell(th_config->client_out);
    bool ok = flush_pending_invokes(); 
    th_assert(ok, "Flush pending invokes failed");
    
    ch = thor_getc(th_config->client_in);
    if (ch != '=') {
	get_exception(ch);
	return;
    }
  }
  c->handle = get_handle();
  // XXX Needs to fixed with smart pointers add_obj_mapping(c->handle, c);
  if (!th_config->veneer_using_futures)
    remap_futures();
}

void begin_if() {
  th_config->inside_control_structure++;
  put_begin_control(th_config->client_out);
  put_if_expr(th_config->client_out);
}

void begin_if_body(th_bool* cond) {
  put_begin_control(th_config->client_out);
  put_if_body(th_config->client_out);
  put_val_or_handle(cond);
}

void begin_else() {
  put_begin_control(th_config->client_out);
  put_else(th_config->client_out);
}

void end_if() {
  put_end_control(th_config->client_out);
  put_if_body(th_config->client_out);
  th_config->inside_control_structure--;
}

void begin_loop() {
  th_config->inside_control_structure++;
  put_begin_control(th_config->client_out);
  put_loop_expr(th_config->client_out);
}

void begin_loop_body(th_bool *cond) {
  put_begin_control(th_config->client_out);
  put_loop_body(th_config->client_out);
  put_val_or_handle(cond);
}

void end_loop() {
  put_end_control(th_config->client_out);
  put_loop_body(th_config->client_out);
  th_config->inside_control_structure--;
}

void begin_foreach() {
  th_config->inside_control_structure++;
  put_begin_control(th_config->client_out);
  put_foreach_iter(th_config->client_out);
}

void end_foreach() {
  put_end_control(th_config->client_out);
  put_foreach_body(th_config->client_out);
  th_config->inside_control_structure--;
}

void begin_break() {
  put_begin_control(th_config->client_out);
  put_break(th_config->client_out);
}

#endif /* BCS */
