/* Copyright Barbara Liskov, MIT, 1996 */

#ifndef _THOR_BCS_H
#define _THOR_BCS_H

#include "config/vdefs/BCS.h"

#if BCS

#define put_begin_control(out) thor_fputc('D', out)
#define put_end_control(out) thor_fputc('E', out)

#define put_new_cell(out) thor_fputc('U', out)
#define put_new_cell_futures(out) thor_fputc('V', out)

#define put_if_expr(out) thor_fputc('f', out)
#define put_if_body(out) thor_fputc('g', out)
#define put_else(out) thor_fputc('h', out)

#define put_loop_expr(out) thor_fputc('l', out)
#define put_loop_body(out) thor_fputc('m', out)

#define put_foreach_iter(out) thor_fputc('x', out)
#define put_foreach_body(out) thor_fputc('y', out)

#define put_break(out) thor_fputc('r', out)

extern void th_cell_new(th_any*);

void begin_if();
void begin_if_body(th_bool*);
void begin_else();
void end_if();

void begin_while();
void begin_while_body(th_bool*);
void end_while();

void begin_foreach();
void end_foreach();

void begin_break();

#define IF(cond) {    \
  begin_if();         \
  th_bool *veneertmp_if = cond;\
  begin_if_body(veneertmp_if);\

#define ELSE } begin_else(); {

#define END_IF end_if(); }

#define WHILE(cond) {  \
  begin_while();       \
  th_bool *veneertmp_while = cond;\
  begin_while_body(veneertmp_while);\

#define END_WHILE end_while(); }

#define FOREACH(var, iter) {\
  begin_foreach();          \
  var = iter;               \

#define END_FOREACH end_foreach(); }

/* end of control structures stuff. */

#endif //BCS

#endif /* _THOR_BCS_H */
