/* Copyright Barbara Liskov, MIT, 1996 */

/* Binary client to Thor, linked with FE in same address space. */

extern "C" {
#include <string.h>
#include <stdlib.h>
}

#include "binary_veneer.h"
#include "th_string.h"
#include "fe/client/binary_interface.h"
#include "fe/init_fe.h"
#include "common/th_assert.h"

extern "C" {
    connection new_connection(int, int);
    int pipe (int filedes[2]);
}

#if !SHM

int to_fe[2];   /* pipes */
int from_fe[2];

FILE *fe_in;  /* FE input from client */
FILE *fe_out; /* FE output to client */
#endif

#if SHM
ShmServer *server; /* only needed in this, the local version */
#endif

connection c;
th_any *_force_tmp;

// #define MAX_ARGS 5

bool open_frontend (char const* fe_location, char const* flags) 
{
  /* effects- sets up a connection with the FE and returns a socket.
     errors- return FALSE if its not possible to set up a connection
     with the FE.
     */

  char *current;
  int len;

  char **argv;
  argv = new char*[MAX_ARGS];   // XXX - This is a kluge, should 
                                // do dynamically
  int argc = 1;
  argv[0] = "fe";

  char* flags2 = (char *) strdup(flags);
  current = strtok(flags2, " ");
  if (current) {
    loop {
      th_assert(argc < MAX_ARGS, "Too many arguments, change MAX_ARGS");
      len = strlen(current);
      argv[argc] = new char[len + 1];
      strcpy(argv[argc], current);
      argc++;
      if ((current = strtok(0, " ")) == 0)
        break;
    }
  }
  free (flags2);
  argv[argc] = 0;   /* standard requires this */

#if !SHM
  if ((pipe(to_fe) == -1) || (pipe(from_fe) == -1))
    return FALSE;
  c = new_connection(to_fe[0], from_fe[1]);
  th_config->client_in = fdopen(from_fe[0], "r");
  th_config->client_out = fdopen(to_fe[1], "w");
  fe_in = fdopen(to_fe[0], "r");
  fe_out = fdopen(from_fe[1], "w");
#else
  server = new ShmServer(256);
  client = server->asClient();
#endif
  init_fe(argc, argv);
  initDispatch();

  return TRUE;
}
  
bool transfer_control_to_fe() {
#if COLLECT_VENEER_STATS
  ++veneer_flushes;
#endif    

#if !SHM
  thor_fflush(th_config->client_out);
  bool eof = binarySingleOp(c, 0, th_config->client_out);
#else
  bool eof = binarySingleOp(server);
#endif
  return !eof;
}

