/* Copyright Barbara Liskov, MIT, 1996 */

#ifndef _THOR_PROMISE_H
#define _THOR_PROMISE_H

// Promises promises

#include "config/vdefs/PROMISES.h"

#if  PROMISES

struct basic_value {
  public:
  basic_value(int i) {tag = Int; val.i = i;}
  basic_value(float r) {tag = Real; val.r = r;}
  basic_value(bool b) {tag = Bool; val.b = b;}
  basic_value(char c) {tag = Char; val.c = c;}

  enum {Int, Real, Bool, Char} tag;
  union {
    int i;
    float r;
    bool b;
    char c;
  } val;
};

#define NEW_TH_OBJ_BASIC(handle, th_type, result) 			      \
  do {									      \
    int _handle = handle;						      \
    if (!(result = (th_type *)get_th_obj(_handle))) 		      	      \
         result=new th_type(_handle, 0);				      \
 } while(0)

void begin_invoke(basic_value receiver, int method_index, bool
                  allow_deferred_invoke, bool promises);

// With promises basic type arguments are always tagged.
#define put_null(x) put_null_tagged(x)
#define put_int(x)  put_int_tagged(x)
#define put_real(x) put_real_tagged(x)
#define put_char(x) put_char_tagged(x)
#define put_bool(x) put_bool_tagged(x)

#define put_new_promise(out) thor_fputc('X', out)

// Unfortunately, these functions must reside inside the veneer so
// that they can check whether or not futures are enabled.

void put_val_or_handle(th_int *p);
void put_val_or_handle(th_bool *p);
void put_val_or_handle(th_char *p);
void put_val_or_handle(th_real *p);

void get_result_promise(th_int **p);
void get_result_promise(th_bool **p);
void get_result_promise(th_char **p);
void get_result_promise(th_real **p);

int new_promise(int);

bool claim_promise();

#endif /* PROMISES */

#endif /* _THOR_PROMISE_H */
