/* Copyright Barbara Liskov, MIT, 1996 */

#ifndef _REFERENCE_H
#define _REFERENCE_H

// This file contains the definition of a generic "smart" pointer that is used
// in the client veneer to pass Thor objects around

// A Smart pointer contains an index into a handle table array that also
// contains the reference count

#include "vtable.h"

class Th_Reference {
  public:
    Th_Reference();
    // effects: Default value set to an invalid index.

    Th_Reference(int index, int dummy);
    // requires: index to have been returned Vtable::get_reference
    // effects: Returns a smart pointer with index "index". Increments the
    //          refcount of this index. Dummy parameter has been added just to
    //          prevent implicit conversion from int to Th_Reference

    Th_Reference(const Th_Reference& x);
    // effects: Increments the reference count for this's index

    ~Th_Reference();
    // effects: Decrement reference count of index

    Th_Reference& operator=(const Th_Reference& x);
    // effects: Sets the index of "this" to be the index in x
    //          Increments the reference count for x's index and decrements it
    //          for the entry correspoding to the index in this

    int __index; // Index into the Veneer table
};

extern Th_Reference get_reference(int handle);
    // effects: Given a handle, generates a smart pointer and returns it



inline Th_Reference::Th_Reference() {
    __index = 0;
    Vtable::addref(__index);
}

inline Th_Reference::Th_Reference(int index, int dummy) {
    __index = index;
    Vtable::addref(__index);
}

inline Th_Reference::~Th_Reference() {
    Vtable::subref(__index);
}

inline Th_Reference::Th_Reference(const Th_Reference& x) {
    __index = x.__index;
    Vtable::addref(__index);
}

inline Th_Reference& Th_Reference::operator=(const Th_Reference& x) {
    Vtable::addref(x.__index);
    Vtable::subref(__index);
    __index = x.__index;
    return *this;
}

#endif /* _REFERENCE_H */
