#include "th_array.h"
#include "th_Class.h"
#include "th_string.h"

template <class T > T th_array<T >::fetch(int i)
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::store(int i, T val)
	/* signals(bounds) */
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 1, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   put_handle(Vtab->get_handle(val.__index));
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > int th_array<T >::length()
{
   RETURN_ZERO_INT_IF_EXC();
   int res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 2, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_int(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > void th_array<T >::append(T val)
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 4, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_handle(Vtab->get_handle(val.__index));
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > th_array<T > th_array<T >::subarray(int first, int length)
{
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   th_array<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 5, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   INCR_BY_SIZE(0+2*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(first);
   put_int(length);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_array<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::predict(int s)
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 6, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(s);
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > T th_array<T >::remove()
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 7, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::trim(int lb, int length)
	/* signals(negative_size, bounds) */
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 8, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+2*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(lb);
   put_int(length);
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > th_array<T > th_array<T >::extract(int first, int length)
{
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   th_array<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 9, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   INCR_BY_SIZE(0+2*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(first);
   put_int(length);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_array<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::concat(th_array<T > b)
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 10, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_handle(Vtab->get_handle(b.__index));
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > bool th_array<T >::empty()
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 11, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > int th_array<T >::low()
{
   RETURN_ZERO_INT_IF_EXC();
   int res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 12, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_int(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > int th_array<T >::high()
{
   RETURN_ZERO_INT_IF_EXC();
   int res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 13, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_int(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > T th_array<T >::bottom()
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 14, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > T th_array<T >::top()
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 15, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::append_low(T x)
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 16, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_handle(Vtab->get_handle(x.__index));
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > T th_array<T >::remove_low()
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 17, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_array<T >::set_low(int lb)
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 18, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(lb);
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > bool th_array<T >::equal(th_array<T > a)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 20, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(a.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_array<T >::similar(th_array<T > a)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 21, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(a.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > th_array<T > th_array<T >::copy()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   th_array<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 22, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_array<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_string th_array<T >::unparse()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   th_string res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 23, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_string, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_Class th_array<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_array<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("array_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "array_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
