#include "th_arrayE.h"
#include "th_array.h"
#include "th_Class.h"

template <class T > th_array<T > th_arrayE<T >::create()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   th_array<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_array<T >);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_array<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_Class th_arrayE<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_arrayE<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("arrayE_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "arrayE_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
