#include "th_empty_maybe.h"
#include "th_maybe.h"
#include "th_Class.h"
#include "th_string.h"

template <class T > bool th_empty_maybe<T >::is_full()
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_empty_maybe<T >::is_empty()
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 1, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > T th_empty_maybe<T >::value_full()
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 2, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > null th_empty_maybe<T >::value_empty()
{
   RETURN_ZERO_INT_IF_EXC();
   null res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 3, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_null(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_empty_maybe<T >::equal(th_maybe<T > m)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 4, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(m.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_empty_maybe<T >::similar(th_maybe<T > m)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 5, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(m.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > th_maybe<T > th_empty_maybe<T >::copy()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_maybe<T >);
   th_maybe<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 6, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_maybe<T >);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_maybe<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_string th_empty_maybe<T >::unparse()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   th_string res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 7, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_string, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_Class th_empty_maybe<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_empty_maybe<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("empty_maybe_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "empty_maybe_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
