#include "th_sequence.h"
#include "th_Class.h"
#include "th_string.h"

template <class T > T th_sequence<T >::fetch(int i)
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > int th_sequence<T >::length()
{
   RETURN_ZERO_INT_IF_EXC();
   int res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 1, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_int(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_sequence<T >::empty()
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 3, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > th_sequence<T > th_sequence<T >::replace(int i, T val)
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   th_sequence<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 4, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   INCR_BY_SIZE(0+1*sizeof(int)+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   put_handle(Vtab->get_handle(val.__index));
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_sequence<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_sequence<T > th_sequence<T >::append(T val)
{
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   th_sequence<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 5, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_handle(Vtab->get_handle(val.__index));
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_sequence<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_sequence<T > th_sequence<T >::extract(int first, int length)
	/* signals(bounds, negative_size) */
{
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   th_sequence<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 6, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   INCR_BY_SIZE(0+2*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(first);
   put_int(length);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_sequence<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_sequence<T > th_sequence<T >::concat(th_sequence<T > s)
{
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   th_sequence<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 7, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_handle(Vtab->get_handle(s.__index));
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_sequence<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > bool th_sequence<T >::equal(th_sequence<T > a)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 9, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(a.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > bool th_sequence<T >::similar(th_sequence<T > a)
{
   RETURN_ZERO_INT_IF_EXC();
   bool res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 10, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   put_handle(Vtab->get_handle(a.__index));
   if (do_invoke(FALSE)) {
      get_bool(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > th_sequence<T > th_sequence<T >::copy()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   th_sequence<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 11, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_sequence<T >);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_sequence<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_string th_sequence<T >::unparse()
{
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   th_string res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 12, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_string);
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_string, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_Class th_sequence<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_sequence<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("sequence_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "sequence_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
