#include "th_vec.h"
#include "th_Class.h"

template <class T > T th_vec<T >::fetch(int i)
	/* signals(bounds) */
{
   RETURN_INVALID_HANDLE_IF_EXC(T);
   T res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(T);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), T, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > void th_vec<T >::store(int i, T val)
	/* signals(bounds) */
{
   RETURN_VOID_IF_EXC();
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 1, &method_handle);
   RETURN_VOID_IF_EXC();
   INCR_BY_SIZE(0+1*sizeof(int)+1*sizeof(int)); // Message size of the arguments
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   put_handle(Vtab->get_handle(val.__index));
   if (do_invoke(TRUE)) {
   }
   end_invoke(TRUE);
}

template <class T > int th_vec<T >::length()
{
   RETURN_ZERO_INT_IF_EXC();
   int res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 2, &method_handle);
   RETURN_ZERO_INT_IF_EXC();
   begin_invoke(Vtab->get_handle(__index), method_handle, FALSE, FALSE);
   if (do_invoke(FALSE)) {
      get_int(&res);
   }
   end_invoke(FALSE);
   return res;
}

template <class T > th_Class th_vec<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_vec<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("vec_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "vec_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
