#include "th_vecE.h"
#include "th_vec.h"
#include "th_Class.h"

template <class T > th_vec<T > th_vecE<T >::create(int i)
{
   RETURN_INVALID_HANDLE_IF_EXC(th_vec<T >);
   th_vec<T > res;
   static int method_handle = 0;
   if (!method_handle) memoize_method_handle(Class_Name(), 0, &method_handle);
   RETURN_INVALID_HANDLE_IF_EXC(th_vec<T >);
   INCR_BY_SIZE(0+1*sizeof(int)); // Message size of the arguments
   INCR_BY_SIZE_IF_FUTURES(1*sizeof(int)); // Message size of non-basic return futures
   begin_invoke(Vtab->get_handle(__index), method_handle, TRUE, FALSE);
   put_int(i);
   if (do_invoke(TRUE)) {
      NEW_TH_OBJ(get_handle(), th_vec<T >, res);
   }
   end_invoke(TRUE);
   return res;
}

template <class T > th_Class th_vecE<T >::Class() {
   static th_any class_stub = th_config->invalid_obj;
   if (th_is_invalid(class_stub)) {
      class_stub = lookup_wellknown(Class_Name());
   }
   return CAST_TYPE(th_Class, class_stub);
}
template <class T > char *th_vecE<T >::Class_Name() {
  static char *CName = 0;
  if (! CName) {
    char *PNm = th_string_to_chars(_th_convert_type_name(T::Class().name()));
    int len = strlen("vecE_OF_") + strlen(PNm) + 1;
    char *p = new char[len];
    strcpy(p, "vecE_OF_");
    strcat(p, PNm);
    CName = p;
  }
  return (CName);
}
