/* Copyright Barbara Liskov, MIT, 1996 */

#ifndef _THOR_SUPPORT_H
#define _THOR_SUPPORT_H

// Primitive types

// XXX Because the underlying run-time system already uses the name "th_null"
// for something else, we cannot use it in the C++ veneer for "null".
// "null" is defined as "unsigned int" so it is NOT the same as "int.
// This is necessary for it to be used as a parameter.
static const unsigned int th_nil = 0;
typedef unsigned int null;

// The following magic piece of code checks for presence of a predefined
// bool type, and only redefines bool if that type is not present.
#define NEED_BOOL_TYPE
#if defined(__GNUC__) && defined(__cplusplus)
#include <_G_config.h>
#if _G_HAVE_BOOL
/* There is a predefined bool type.  So try to avoid name clashes with that */
#undef NEED_BOOL_TYPE
#endif
#endif
#ifdef NEED_BOOL_TYPE
typedef unsigned char bool;
#endif
#undef NEED_BOOL_TYPE

#include "binary_veneer.h"

#endif /* _THOR_SUPPORT_H */
