-module(test_stubs).
-export([go1/2, go2/2]).

%======================================================================
% go1(FE_spec, Depth):
%    Connects to the FE specified by "FE_spec"
%    and traverses the database to the depth "Depth" displaying
%    all strings found.
%
%    Assumes that the current database contains a list of strings.
%    Run .../thor/or/promises-db.or for a test.
%
%    This function tests partially the veneer(stubs) for lists and strings.
%======================================================================

go1(FE_spec, Depth) ->
  binary_veneer_EC:load_C_veneer(),
  case binary_veneer_EC:begin_session(FE_spec) of
    true -> 
      print_strings(Depth),
      binary_veneer_EC:end_session();
    false ->
      io:format("***Can't begin a session~n", [])
  end,
  binary_veneer_EC:close_C_veneer().

print_strings(N) ->
  Root_H = binary_veneer_EC:lookup_wellknown("root"),
  print_strings1(Root_H, N).

print_strings1(H, 0) -> true;
print_strings1(H, N) ->
  String_H = th_list:first_(H),
  Str = binary_veneer_EC:th_chars(String_H),
  io:format("==> ~w~n", [list_to_atom(Str)]),
  print_strings1(th_list:rest_(H), N-1).


%======================================================================
% go2(FE_spec, I):
%    Connects to the FE specified by "FE_spec"
%    and compares the input integer "I" with the first integer in DB.
%
%    Assumes that the first element reachable from the root is an integer.
%    Run ??? for a test.
%
%    This function tests (partially) the veneer(stubs) for integers.
%======================================================================

go2(FE_spec, I) ->
  binary_veneer_EC:load_C_veneer(),
  case binary_veneer_EC:begin_session(FE_spec) of
    true -> 
      test_int_ge(I),
      binary_veneer_EC:end_session();
    false ->
      io:format("***Can't begin a session~n", [])
  end,
  binary_veneer_EC:close_C_veneer().

test_int_ge(I) ->
  Root_H = binary_veneer_EC:lookup_wellknown("root"),
  Int_H = th_list:first(Root_H),
  case th_int:ge_(Int_H, I) of
    0 -> io:format("~d is smaller.~n",[]);
    1 -> io:format("~d is larger.~n",[])
  end.

