-module(test_thor_server).
-export([go/0]).

go()->
  thor_server_EC:start_thor_server(),
  help_message(),
  go1().

help_message() ->
  io:format("~n", []),
  io:format("1. Begin session~n", []),
  io:format("2. End session~n", []),
  io:format("3. Lookup wellknown object~n", []),
  io:format("4. Commit transaction~n", []),
  io:format("5. Abort transaction~n", []),
  io:format("6. Enable futures~n", []),
  io:format("7. Disable futures~n", []),
  io:format("8. Force garbage collection~n"),
  io:format("~n", []),
  io:format("h. This help.~n", []),
  io:format("q. Quit~n", []).

go1() ->
  case io:read('cmd> ') of
    {term, 1} ->
      {term, FE_spec} = io:read('FE spec : '),
      thor_server ! {self(), begin_session, FE_spec},
      receive
	false ->
	  io:format("FE ~s could not be opened.~n", [FE_spec]);
	true ->
	  io:format("FE ~s has been opened.~n", [FE_spec])
      end;

    {term, 2} ->
      thor_server ! {self(), end_session},
      receive
	false ->
	  io:format("The FE could not be closed.~n", []);
	true ->
	  io:format("The FE has been closed.~n", [])
      end;

    {term, 3} ->
      {term, Wellknown} = io:read('Wellknown : '),
      thor_server ! {self(), lookup_wellknown, Wellknown},
      receive
	Handle ->
	  io:format("The handle ~w has been received.~n", [Handle])
      end;

    {term, 4} ->
      thor_server ! {self(), commit_trans},
      receive
	false ->
	  io:format("The transaction could not be committed.~n", []);
	true ->
	  io:format("The has been committed.~n", [])
      end;

    {term, 5} ->
      thor_server ! {self(), abort_trans},
      receive
	Any ->
	  io:format("The transaction has been aborted.~n", [])
      end;

    {term, 6} ->
      thor_server ! {self(), enable_futures},
      receive
	Any ->
	  io:format("The future mechanism has been enabled.~n", [])
      end;

    {term, 7} ->
      thor_server ! {self(), disable_futures},
      receive
	Any ->
	  io:format("The futures mechanism has been disabled.~n", [])
      end;

    {term, 8} ->
      thor_server ! {self(), fe_force_gc},
      receive
	Any ->
	  io:format("The garbage collector has been activated.~n", [])
      end;

    {term, h} ->
      help_message();

    {term, q} ->
      cleanup_and_exit();

    Else ->
      unknownCmd()
  end,
  go1().

cleanup_and_exit()->
  thor_server ! {self(), quit},
  io:format("Good bye...~n", []),
  exit(0).

unknownCmd() ->
  io:format("Unknown command...~n", []).

