-module(binary_veneer_EC).
-export( [
	% init & close veneer :
 	   load_C_veneer/0, 
	   close_C_veneer/0,

	% Stub object interface :
	   put_int/1,
	   put_char/1,
 	   put_bool/1,
	   put_handle/1,
 	   put_string/1,
	
	   get_int_E/0,
	   get_char_E/0,
 	   get_bool_E/0,
	   get_handle_E/0,
 	   get_string_E/0,
	
	   memoize_method_H/2,
	   begin_invoke/3,
	   do_invoke/1,
	   end_invoke/1,

	% FE command interface :
	   begin_session/1,
	   end_session/0,
	   lookup_wellknown/1,
	   commit_trans/0,
	   abort_trans/0,
	   enable_futures/0,
	   disable_futures/0,
	   fe_force_gc/0,

	% Other auxiliary functions :
	   th_chars/1,
  	   th_basics_new/4
         ]
       ).

%========================================================================
%	Init & Close veneer
%========================================================================

load_C_veneer() ->
  Files   = [ "/home/am2/euisuk/thor/client/Erlang/veneer/binary_veneer.o", 
              "/home/am2/euisuk/thor/client/Erlang/veneer/hostname.o"
            ],
  C_funcs = [ put_int,		% You can have only 20 functions / file.
	      put_char,
 	      put_bool,
	      put_handle,
 	      put_string,
	
	      get_int_E,
	      get_char_E,
 	      get_bool_E,
	      get_handle_E,
 	      get_string_E,

	      memoize_method_H,
	      begin_invoke,
	      do_invoke,
	      end_invoke,

	      open_frontend,
	      close_frontend,
 	      lookup_wellknown,
	      commit_or_abort_trans,
%	      enable_or_disable_futures,
%  	      fe_force_gc	% Removed because of the 20-function limit
	      th_chars,
	      th_basics_new
     	    ],
%  Aux_funcs = [ th_chars,
%   	        th_string_new
%	      ],
  foreign:start(),
  foreign:load(c, Files, C_funcs, []).

close_C_veneer() ->
  foreign:stop().


%========================================================================
%	Stub object interface
%========================================================================

put_int(X) ->
  foreign:call(c, put_int, [{int, X}], int).

put_char(X) ->			%%% Does this work?
  foreign:call(c, put_char, [{int, X}], int).

put_bool(X) ->
  foreign:call(c, put_bool, [{int, X}], int).

put_handle(X) ->
  foreign:call(c, put_handle, [{int, X}], int).

put_string(X) ->
  foreign:call(c, put_string, [{string, X}], int).
	
get_int_E() ->
  foreign:call(c, get_int_E, [], int).

get_char_E() ->
  foreign:call(c, get_char_E, [], int).

get_bool_E() ->
  foreign:call(c, get_bool_E, [], int).

get_handle_E() ->
  foreign:call(c, get_handle_E, [], int).

get_string_E() ->
  foreign:call(c, get_string_E, [], int).

memoize_method_H(Type_name, Index) ->
  foreign:call(c, memoize_method_H, [{string, Type_name}, {int, Index}], int).

begin_invoke(Self, Method_H, Flag) ->
  foreign:call(c, begin_invoke, [{int, Self}, {int, Method_H}, {int, Flag}], int).

do_invoke(Flag) ->
  foreign:call(c, do_invoke, [{int, Flag}], int).

end_invoke(Flag) ->
  foreign:call(c, end_invoke, [{int, Flag}], int).


%========================================================================
%	FE command interface
%========================================================================

begin_session(FE_spec) ->		% Returns bool.
  case foreign:call(c, open_frontend, [{string, FE_spec}], int) of
    0 -> false;  	% Cannot start FE
    _ -> true
  end.

end_session() ->			% Returns bool.
  case foreign:call(c, close_frontend, [], int) of
    0 -> false;		% Cannot close FE
    _ -> true
  end.

lookup_wellknown(Wellknown) ->		% Returns a handle or 0.
  foreign:call(c, lookup_wellknown, [{string, Wellknown}], int).

commit_trans() ->			% Returns bool.
  case foreign:call(c, commit_or_abort_trans, [{int, 1}], int) of
    0 -> false;		% Cannot commit transaction
    _ -> true
  end.

abort_trans() ->			% Returns void.
  foreign:call(c, commit_or_abort_trans, [{int, 0}], int).

enable_futures() ->			% Returns void.
  foreign:call(c, enable_or_disable_futures, [{int, 1}], int).

disable_futures() ->			% Returns void.
  foreign:call(c, enable_or_disable_futures, [{int, 0}], int).

fe_force_gc() ->			% Returns void.
  foreign:call(c, fe_force_gc, [], int).


%========================================================================
%	Auxiliary functions
%========================================================================
% The following functions are not formal part of the veneer.
% They are included here only for convenience, and will be moved
% to somewhere else later.

th_chars(String_H) ->			% Returns a string.
  foreign:call(c, th_chars, [{int, String_H}], string).

th_basics_new(Bool, Char, Int, String) ->
  foreign:call(c, th_basics_new, [{int, Bool}, {int, Char}, {int, Int}, {string, String}], int).
