-module(thor_server_EC).
-export([start_thor_server/0, server/0]).

start_thor_server() ->
  register(thor_server, spawn(thor_server_EC, server, [])).

server() ->
  binary_veneer_EC:load_C_veneer(),
  server1().

server1()->
  receive
    {Client, begin_session, FE_spec} ->
      Client ! binary_veneer_EC:begin_session(FE_spec);
    {Client, end_session} ->
      Client ! binary_veneer_EC:end_session();
    {Client, lookup_wellknown, Wellknown} ->
      Client ! binary_veneer_EC:lookup_wellknown(Wellknown);
    {Client, commit_trans} ->
      Client ! binary_veneer_EC:commit_trans();      
    {Client, abort_trans} ->
      Client ! binary_veneer_EC:abort_trans();
    {Client, enable_futures} ->
      Client ! binary_veneer_EC:enable_futures();
    {Client, disable_futures} ->
      Client ! binary_veneer_EC:disable_futures();
    {Client, fe_force_gc} ->
      Client ! binary_veneer_EC:fe_force_gc();
    {Client, quit} ->
      binary_veneer_EC:close_C_veneer(),
      exit(normal_quit)
  end,
  server1().

