#!/usr/local/bin/perl  

# Very simple Thor veneer for Perl

require 'sys/socket.ph';

sub invoke #(handle, method, args...)
# invoke a method on a Thor object
{
    print FE ("invoke ", join(" ", @_), "\n");
    return &parse(&getline);
}

sub call_proc #(procedure, args...)
# call a Thor procedure
{
    print FE join(" ", @_); print FE "\n";    
    return &parse(&getline);
}    

sub open_frontend # host
# Open a frontend on the given host
{
    ($them) = @ARGV;
    $port = 4201 unless $port;
    $sockaddr = 'S n a4 x8';
    chop($hostname = `hostname`);
    
    ($name, $aliases, $proto) = getprotobyname('tcp');
    ($name, $aliases, $port) = getservbyname($port, 'tcp')  unless $port =~ /^\d+$/;
    ($name, $aliases, $type, $len, $thisaddr) = gethostbyname($hostname);
    ($name, $aliases, $type, $len, $thataddr) = gethostbyname($them);
    
    $this = pack($sockaddr, &AF_INET, 0, $thisaddr);
    $that = pack($sockaddr, &AF_INET, $port, $thataddr);
    
    socket(FE, &PF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
    bind(FE, $this) || die "bind: $!";
    connect(FE, $that) || die "connect: $!";
    select(FE); $| = 1;  select(stdout);

# skip welcome message
    &getline;    &getline;
    $th_last_ex = "";
}

sub wellknown #(name)
# Lookup a wellknown Thor name
{
    &call_proc(("wellknown", shift));
}

sub parse #(s)
# Parse the return results from Thor, setting th_last_ex as appropriate
{
    local($s) = shift;
    split(" ", $s);
    if (shift != "=") {
	$th_last_ex = $s;
    }
    return @_;
}    

sub getline	{ while (<FE>) {return $_;}}
# return the next line sent by the frontend

# Stubs for various Thor methods

sub list_first #(list) returns (any)
{_th_res =  &invoke(shift, "first");    shift @_th_res;}

sub list_rest #(list) returns (list)
{_th_res =  &invoke(shift, "rest");    shift @_th_res;}

sub string_concat #(string1, string2)
{_th_res = &invoke(shift, "concat", shift);    shift @_th_res;}

sub string_length #(string) returns (int)
{_th_res = &invoke(shift, "length");   shift @_th_res;}

sub string_fetch # (th_string s1, int index) returns(char)
{_th_res = &invoke(shift, "fetch", shift);   shift @_th_res;}

sub string_equal # (th_string s1, th_string s2) returns (bool)
{_th_res = &invoke(shift, "equal", shift);   shift @_th_res;}

sub th_str # (string)  
# Create a new Thor string
{return join("", ("\"", shift, "\""));}

sub th_chars # (th_str)
# Return the representation for a Thor string
{
    local($buff);

    print FE ("print ", shift, "\n");

    if (&getline =~ /\(([0-9+]).*\n/)    { # find the number of characters to get
	while (length($buff)<$1 && !eof(FE)) { # keep getting lines until they're gotten
	    $buff = join("", ($buff, &getline));
	}
	chop($buff);
	return $buff;
    }
    else  {return "";}
}


