
#include "core_interface.h"

/*
size_t _th_sizeof_core_value(core_value v) {
  switch (v.tag) {
    case 'h' : return sizeof(th_handle);
    case 'c' : return sizeof(int);
    case 'b' : return sizeof(int);
    case 'i' : return sizeof(int);
/   case 'r' : return sizeof(real); /
  default: th_assert(0, "Invalid tag\n");
  }
  return 0;
}
*/

void _th_put_core_value(core_value v) {
  switch (v.tag) {
    case 'h' : _th_put_handle(v.val.h); break;
    case 'c' : _th_put_char(v.val.c); break;
    case 'b' : _th_put_bool(v.val.b); break;
    case 'i' : _th_put_int(v.val.i); break;
/*  case 'r' : _th_put_real(v.val.r); break; */
  default: th_assert(0, "Invalid tag\n");
  }
}

void _th_get_core_value(core_value *v) {
  switch (v->tag) {
    case 'h' : _th_get_handle(&(v->val.h)); break;
    case 'c' : _th_get_char(&(v->val.c)); break;
    case 'b' : _th_get_bool(&(v->val.b)); break;
    case 'i' : _th_get_int(&(v->val.i)); break;
/*  case 'r' : _th_get_real(&(v->val.r)); break; */
  default: th_assert(0, "Invalid tag\n");
  }
}

bool _th_put_string(char const *s)  {
  int len = strlen(s)+1;

  _th_raw_put_int(len);

  WORD_ALLIGN(len);      /* In case of SHM */

  return (_th_fwrite(s, 1, len, th_config->client_out) > 0);
}


bool _th_get_string(char *buf, int size) {
  int len;

  _th_get_int(&len);

  WORD_ALLIGN(len);      /* In case of SHM */

  th_assert(len <= size, "Size not big enough to accomodate string");

  return (_th_fread(buf, 1, len, th_config->client_in) > 0);
  /* XXX What if there is an interrupt or fewer bytes returned */
}

void _th_resynchronize() {

#if SHM
  XXX This code needs to be fixed!!!
  /* Check if the FE has sent an immediate exception and
     resynchronize */
  if (th_config->client->is_immediate_flag()) {
    th_config->client->resynchronize_buffers();
    bool ok = _th_transfer_control_to_fe();
    th_assert(ok, "Incomplete FE operation");
  }
#else
  SEND_MSG_SIZE();
  _th_put_resynch(th_config->client_out);
  if (!_th_get_fe_response())
    /* Resynchronization protocol should not fail */
    th_fail("Could not resynchronize with frontend after an exception");
#endif

}
