#ifndef _CORE_H
#define _CORE_H

/*=========================================================================
 * This file contains some basic definitions used in the core veneer.
 *=======================================================================*/

typedef int th_handle;                    /* Subject to change without */
typedef int null;			  /* notice */

typedef struct {
  char tag;                    /* Must be in {'c', 'b', 'i', 'r', 'h'} */
  union {
    th_handle h;               /* Common case; can be auto-initialized */
    char c;
    bool b;
    int  i;
    float r;
    null n;
  } val;
} core_value ;

/* size_t _th_sizeof_core_value(core_value v); */
#define _th_sizeof_core_value(v)      sizeof(int);

void _th_put_core_value(core_value v);
void _th_get_core_value(core_value *v);

#define FALSE 0
#define TRUE 1

#endif /* _CORE_H */
