
#include "core_interface.h"

Veneer_Config* th_config;                  /* Variable used for globals */

void th_init_config() {
  th_config = (Veneer_Config *) malloc(sizeof(Veneer_Config));

  th_config->iobj = 0;

  th_config->exc[0] = 0;

  th_config->fe_state = fe_closed;
  
  th_config->batched_call = FALSE;
  
  sprintf(th_config->fe_cmd, "fe");
  
#ifdef SPARC
  th_config->batching = FALSE;        /* Do not use futures by default.*/
#else
  th_config->batching = FALSE;         /* XXX For now */
#endif

#if !SHM
  th_config->current_msg_size = 1;
#endif

#if BCS
  th_config->inside_bcs = 0;
#endif

#if COLLECT_VENEER_STATS
  th_config->veneer_invokes = 0;
  th_config->veneer_invokes_with_promises = 0;
  th_config->veneer_flushes = 0;    
#endif
}
