#ifndef _CONFIG_VENEER_H
#define _CONFIG_VENEER_H

/*=========================================================================
 * Configuration Information for core veneer.  Intended for include by
 * core_interface.h only!
 *=======================================================================*/

#define MAX_EXC_STR_LEN        1024        /* Maximum exception string
					      size */
typedef enum {
    fe_closed, fe_open, fe_slave
} fe_status;

typedef struct {
  /* Global configuration data. */

  th_handle iobj;                          /* Interface object used to */
					   /* communicate with FE */

  char exc[MAX_EXC_STR_LEN];               /* Current exception name */

  char exception_copy[MAX_EXC_STR_LEN];    /* App code gets a pointer */
					   /* to this */ 

  char fe_cmd[1024];                       /* Name of the FE */
                                           /* executable */

  fe_status fe_state;                      /* Status of connection to */
                                           /* fe */
  bool batching;                           /* Are calls being batched */

  bool batch_current_call;                 /* Can current call be batched */

  bool batched_call;                       /* Is there an outstanding batch */

#if SHM
  ShmClient *client;
#else
  FILE *client_in, *client_out;

  int current_msg_size;                    /* Keeps track of current */
                                           /* message size being sent to FE */
#endif

#if COLLECT_VENEER_STATS
    int veneer_invokes;
    int veneer_invokes_with_promises;
    int veneer_flushes;
#endif

} Veneer_Config;                           /* Global configuration data. */


extern Veneer_Config* th_config;           /* Variable used for globals */

#endif /* _CONFIG_VENEER_H */
