#include "core_interface.h"

bool _th_transfer_control_to_fe() {
#if COLLECT_VENEER_STATS
  ++(th_config->veneer_flushes);
#endif    

#if !SHM
  _th_fflush(th_config->client_out);
#endif
  return TRUE;
}

void _th_check_for_exception_at_fe() {
  /* This should send a seperate command to FE?! */

  /* If not batching, there can be no outstanding exceptions at the FE. */
  if (!th_config->batching || !th_config->batched_call)
    return;
  else {
    fprintf(stderr, "Fix exception checking for batching!\n");
    exit(EXIT_FAILURE);
  }
}

th_handle _th_new_handle() {
  /* XXX This function needs to be updated to meet it's specs,
     i.e. support futures. */
  th_handle res;

  _th_get_handle(&res);   
  return res;
}

void _th_unhandled_exc(char const *s) {
  fprintf(stderr, "Unhandled exception: %s\n", s);
  th_shutdown();
  exit(EXIT_FAILURE);
}

void _th_get_exception(char ch) {
  int cnt;      

  th_config->batched_call = FALSE;

  if (ch != FE_EXCEPT_RESULT) {
    fprintf(stderr, "Unexpected character: '%c (%d)'\n", ch, ch);
    exit(EXIT_FAILURE);
  }

  if (ANY_UNHANDLED_EXC())  {     /* client did not handle last exception */
    _th_unhandled_exc(th_config->exc);
  }

  _th_get_string(th_config->exc, MAX_EXC_STR_LEN);

  _th_get_int(&cnt);  /* XXX This is bogus! */
  th_assert(cnt == 0, "FE trying to send exception values?!");

  _th_resynchronize();
}

bool _th_get_fe_response() {

  bool ok;
  char ch;
  
  ok = _th_transfer_control_to_fe();
  th_assert(ok, "Incomplete FE operation");
  
  /* We do not have batched results from the FE. So no call could be
     running at the FE currently */
  th_config->batched_call = FALSE;
  
  ch = _th_getc(th_config->client_in);
  if (ch == FE_NORMAL_RESULT)
    return TRUE;
  _th_get_exception(ch);
  return FALSE;
}

/*
void th_maybe_remap_futures(bool remap) {
  if ((th_config->future_index >= th_config->remap_threshold) || remap) {
    SEND_MSG_SIZE();
    put_remap_futures(th_config->client_out);
    bool ok = transfer_control_to_fe();
    th_assert(ok, "Incomplete FE operation\n");
    th_get_remap_info();
  }
}
*/

th_handle _th_lookup_wellknown(char *wellknown) {
    th_handle result = 0;
  
    RETURN_INVALID_HANDLE_IF_EXC();

    INCR_BY_STRING_MSGSIZE(wellknown);
    SEND_MSG_SIZE();
    _th_put_wellknown(th_config->client_out);
    _th_put_string(wellknown);

    if (_th_get_fe_response())
      _th_get_handle(&result);

    /* XXX th_maybe_remap_futures(); */
    return result;
}

void th_memoize_method_handle(char *type_name, int index, 
			      th_handle *method_handle) {
    RETURN_VOID_IF_EXC();
    INCR_BY_STRING_MSGSIZE(type_name);
    INCR_BY_SIZE(sizeof(int));
    SEND_MSG_SIZE();
    _th_put_lookup(th_config->client_out);
    _th_put_string(type_name);	 
    _th_raw_put_int(index);
    
    if (_th_get_fe_response())
      _th_get_handle(method_handle);
}

void th_begin_normal_invoke(th_handle receiver, int method_handle, char
			    fe_cmd) {
  /* This function is painfully similar to begin_special_invoke and
     they should always both be changed.  The reason for this
     egregious code duplication is for performance reasons.
     */

  INCR_BY_SIZE(sizeof(th_handle));
  INCR_BY_SIZE(sizeof(int));
  SEND_MSG_SIZE();
  _th_fputc(fe_cmd, th_config->client_out);
  _th_put_handle(receiver);                         
  _th_put_handle(method_handle);                           
} 

void th_begin_invoke(core_value receiver, int method_handle, bool batch,
		     bool promises) {

  INC_INVOKES();          /* Increment invocation counts */

  th_config->batch_current_call = batch && th_config->batching;

  if (th_config->batch_current_call) {

#if BCS
    if (th_config->inside_bcs) {
      INC_BCS_INVOKES();                

      th_begin_special_invoke(receiver, method_handle, TH_BCS_INVOKE);
      return;
    }
#endif /* BCS */

#if PROMISES
    if (promises) {
      INC_PROMISE_INVOKES();               /* increment promise invoke count */

      th_begin_special_invoke(receiver, method_handle, TH_PROMISE_INVOKE);
      return;
    }
#endif /* PROMISES */

    th_begin_normal_invoke(receiver.val.h, method_handle, TH_BATCHED_INVOKE);
    return;
  }
   
  th_begin_normal_invoke(receiver.val.h, method_handle, TH_INVOKE);
}

bool th_do_invoke() {
  bool ok;
  char ch;

  if (th_config->batch_current_call) {
    th_config->batched_call = TRUE;
    return TRUE;
  }

  return _th_get_fe_response();
}

void th_end_invoke() {
  /*
  if (th_config->batching && !th_config->batch_current_call) {
    th_maybe_remap_futures(FALSE);
  }
  */
}
