#if !SHM

#include "core_interface.h"

#define TRY(desc,expr) if ((expr) < 0) { perror(desc); return FALSE; }

bool th_get_from_fe (FILE *in, char *buffer, size_t bufsiz) {
  /* effects: Gets bufsiz bytes from in and puts them in buffer */
  if (fgets(buffer, bufsiz, in) == 0) {
    perror("reading from FE");
    return FALSE;
  }
  return TRUE;
}

bool th_send_to_fe (FILE *out, const char *command) {
  /*  effects - sends request to FE listening on net, returns TRUE.
      errors - returns FALSE. */

  if ((fputs(command, out) == EOF) || (!_th_transfer_control_to_fe())) {
    perror("sending to FE");
    return FALSE;
  }
  return TRUE;
}

bool th_discard_lines (FILE *in, int num) {
  int i;
  bool ok;
  char junk[BUFSIZ];
  for(i = 0; i < num; i ++) {
    ok = th_get_from_fe(in, junk, BUFSIZ);
    if (!ok) break;
  }
  return ok;
}

#ifndef SPARC

int th_start_fe(char const* flags) {
  FILE *fe_process;
  char buffer[BUFSIZ];
  long port;
  int ret;

  th_assert ((strlen(th_config->fe_cmd) + strlen(flags) - 1) <= BUFSIZ,
	     "Too many flags for buffer");
  sprintf(buffer, "%s %s", th_config->fe_cmd, flags);
  fe_process = popen(buffer, "r");
  if (fe_process == NULL) {
    fprintf(stderr, "fe: could not start process\n");
    return 0;
  }
    
  /* Read port number from fe */
  if (fgets(buffer, 100, fe_process) == NULL) {
    if (! feof(fe_process)) {
      perror("reading port number from fe");
    }
    pclose(fe_process);
    return 0;
  }

  ret = atoi(buffer);
  if (!ret) {
    fprintf(stderr, "fe: bad port number");
    return 0; /* redundant, but clearer */
  }
  return ret;
}

#endif /* SPARC */

bool th_set_up_conn_parms (char const* fe_location, char const* flags,
			struct sockaddr_in *fe) { 
  if (!fe_location) {

#ifdef SPARC
    fprintf(stderr, "Error: Environment variable FE_LOCATION is not set.\n"
	    "   This version does not support automatic launching of FE.\n");
    return FALSE;
#else
    short port;
    port = th_start_fe(flags);
	
    fe->sin_addr.s_addr = INADDR_ANY;
    fe->sin_port = htons(port);
    th_config->fe_state = fe_slave;
#endif

  } else {
    if (!findport(fe_location, 0, fe)) {
      fprintf(stderr, "%s: could not parse FE location\n", fe_location);
      return FALSE;
    }
    th_config->fe_state = fe_open;
  }
  
  fe->sin_family = AF_INET;
  
  return TRUE;
}

bool _th_open_frontend (char const* fe_location, char const* flags)  {
  int sock;
  struct sockaddr_in fe;
  
  TRY("opening stream socket",
      sock = socket(AF_INET, SOCK_STREAM, 0));
  
  if (!th_set_up_conn_parms(fe_location, flags, &fe)) return FALSE;
  
  TRY("connecting to FE",
      connect(sock, (struct sockaddr*) &fe, sizeof(fe)));
  
  if (sock) {
    th_config->client_in = fdopen(sock, "r");
    th_config->client_out = fdopen(sock, "w");
    th_discard_lines(th_config->client_in, 1);        /* discard greeting */
  }
  
  th_send_to_fe(th_config->client_out, "binary\n");

  return TRUE;
}

#endif /* !SHM */

