#ifndef _CORE_NET_H
#define _CORE_NET_H

/*=========================================================================
 * This file defines the low-level communication interface for a
 * tcp/ip network connection.  This file is intended for inclusion by
 * core_interface.h only!
 *=======================================================================*/

#define _th_fputc(c,f)       fputc(c,f)
#define _th_fgetc(f)         fgetc(f)
#define _th_putc(c)          putc(c)
#define _th_getc(f)          getc(f)
#define _th_fwrite(a,s,l,f)  fwrite(a,s,l,f)
#define _th_fread(a,s,l,f)   fread(a,s,l,f)
#define _th_fflush(f)        fflush(f)
#define _th_fclose(x)        fclose(x)

/* This macro is used in case of SHM to compute the word alligned
   length of a string (core_shm.h). */
#define WORD_ALLIGN(i)

/* Swap bytes when client is using SPARC.  This assumes FE is running
   on Alpha.  Once FE is ported to SPARC, the ifdef should be
   conditioned on a more complex configuration option indicating
   whether or not client and FE are running on same endian architectures.
   */

#ifdef SPARC
#define _th_swap_byte_order(n) ( ((n & 0xff000000) >> 24) | \
                                 ((n & 0xff0000  ) >>  8) | \
				 ((n & 0xff00    ) <<  8) | \
				 ((n & 0xff      ) << 24)   \
			       )
#else /* SPARC */
#define _th_swap_byte_order(n) n
#endif

/* Output characters and integers without type tags. */
#define _th_raw_put_char(x)  (_th_fputc(x, th_config->client_out)!=-1)

#define _th_raw_put_int(x) (_th_fwrite(&(_th_swap_byte_order(x)), sizeof(int), 1, th_config->client_out) > 0)

#define _th_put_null_tagged(x)  \
    (_th_raw_put_char('n') && _th_raw_put_int(x))
#define _th_put_int_tagged(x)  \
    (_th_raw_put_char('i') && _th_raw_put_int(x))
#define _th_put_real_tagged(x)  \
   (_th_raw_put_char('f') && (_th_fwrite(&x, sizeof(real), 1, th_config->client_out)> 0))
#define _th_put_char_tagged(x)  \
    (_th_raw_put_char('c') && (_th_fwrite(&x, sizeof(char), 1, th_config->client_out)> 0))
#define _th_put_bool_tagged(x)  \
    (_th_raw_put_char('b') && (_th_fwrite(&x, sizeof(char), 1, th_config->client_out)> 0))
#define _th_put_handle_tagged(x) \
    (_th_raw_put_char('h') && _th_raw_put_int(x))

#define _th_put_null(x)  _th_raw_put_int(x)
#define _th_put_int(x)   _th_raw_put_int(x)
#define _th_put_real(x)  _th_fwrite(&x, sizeof(real), 1, th_config->client_out)
#define _th_put_char(x)  do { \
    int __v = (int) x; \
    _th_raw_put_int(__v); \
} while(0)
#define _th_put_bool(x) do { \
    int __v = (int) x; \
    _th_raw_put_int(__v); \
}while(0)

#define _th_put_handle(x) _th_raw_put_int(x)

/*=========================================================================
 * Macros for getting data from the FE
 * Data received from the FE is never tagged.
 *=======================================================================*/

#define _th_get_int(i_ptr) do {\
   _th_fread(i_ptr, sizeof(int), 1, th_config->client_in); \
   *i_ptr = _th_swap_byte_order(*i_ptr); \
} while(0)

#define _th_get_null(i_ptr) _th_get_int(i_ptr)

#define _th_get_real(r_ptr) \
   _th_fread(r_ptr, sizeof(int), 1, th_config->client_in)

#define _th_get_char(c_ptr) do { \
    int __v; \
    _th_get_int(&__v);\
    *c_ptr = (char) __v;\
}while(0)

#define _th_get_bool(b_ptr)  do { \
    int __v; \
    _th_get_int(&__v);\
    *b_ptr = (bool) __v;\
}while(0)

#define _th_get_handle(h_ptr)   _th_get_int(h_ptr);     /* Handles are ints*/

/*=========================================================================
 * Macros to handle the message size counter.
 *=======================================================================*/

/* Get the size of a string that is being sent -- including the length */

#define INCR_BY_STRING_MSGSIZE(s)\
do {th_config->current_msg_size += ((sizeof(int) + strlen((s)) + 1)); } while (0)
  
/* Increment the message counter by b number of bytes */

#define INCR_BY_SIZE(b)\
    do { th_config->current_msg_size += b; } while (0)

/* If batching is enabled, then this macro will increment current_msg_size */

#define INCR_BY_SIZE_IF_BATCHING(b)\
    do { if (th_config->batching) th_config->current_msg_size += b; } while (0)

/* Send the message size counter and reset it to 1 (for the command character
 *  of the next command) */

#define SEND_MSG_SIZE()\
    do { _th_raw_put_int(th_config->current_msg_size);\
    th_config->current_msg_size = 1;} while (0)

#endif /* _CORE_NET_H */






