#ifndef _CORE_SHM_H
#define _CORE_SHM_H

/*=========================================================================
 * This file defines the low-level communication interface for a
 * shared memory connection.  This file is intended for inclusion by
 * core_interface.h only!
 *=======================================================================*/

#define _th_fputc(c,f)       _th_putc(c)
#define _th_fgetc(f)         th_config->client->get()
#define _th_putc(c)          (th_config->client->put((int)c), c)
#define _th_getc(f)          _th_fgetc(f)

/*=========================================================================
    The "_th_fread" and "_th_fwrite" macros can only write word-aligned
    data into the shared-memory pipe, so the assertion checks are added to
    make sure this happens. Of course, this constrains the use of
    "_th_fread" and "_th_fwrite" in calling code: the length of the
    buffer must be a multiple of 4.
 *=======================================================================*/

#define _th_fwrite(a,s,l,f)  (assert((s*l & 3) == 0), \
			       th_config->client->write((int *)(void *)a, \
					     s*l/sizeof(int)), TRUE)
#define _th_fread(a,s,l,f)   (assert((s*l & 3) == 0), \
			       th_config->client->read((int *)(void *)a, \
					    s*l/sizeof(int)), TRUE)

/* Compute the word alligned length of a string. */
#define WORD_ALLIGN(i)       i = (i + sizeof(int) - 1)/sizeof(int)

#define _th_fflush(f)        0
#define _th_fclose(x)        0

/* Output characters and integers without type tags. */

#define _th_raw_put_char(x) th_config->client->put(x)
#define _th_raw_put_int(x)  th_config->client->put(x)

#define _th_put_null_tagged(x)\
      (th_config->client->put('n'), th_config->client->put(x))
#define _th_put_int_tagged(x)\
      (th_config->client->put('i'), th_config->client->put(x))
#define _th_put_real_tagged(x)\
      (th_config->client->put('f'), th_config->client->put(*(int *)(void *)&x))
#define _th_put_char_tagged(x)\
      (th_config->client->put('c'), th_config->client->put((int)x))
#define _th_put_bool_tagged(x)\
      (th_config->client->put('b'), th_config->client->put((int)x))
#define _th_put_handle_tagged(x)\
      (th_config->client->put('h'), th_config->client->put(x))

#define _th_put_null(x)   th_config->client->put(x)
#define _th_put_int(x)    th_config->client->put(x)
#define _th_put_real(x)   th_config->client->put(*(int *)(void *)&x)
#define _th_put_char(x)   th_config->client->put((int)x)
#define _th_put_bool(x)   th_config->client->put((int)x)

#define _th_put_handle(x) th_config->client->put(x)

/*=========================================================================
 * Macros for getting data from the FE
 * Data received from the FE is never tagged.
 *=======================================================================*/

#define _th_get_null(x) (*x = th_config->client->get())
#define _th_get_int(x)  (*x = th_config->client->get())
#define _th_get_real(x) (*(int *)(void *)x = th_config->client->get())
#define _th_get_char(x) (*x = (char)th_config->client->get())
#define _th_get_bool(x) (*x = (bool)th_config->client->get())
#define _th_get_handle(x) (*x = (th_handle)th_config->client->get())

/*=========================================================================
 * Macros to handle the message size counter are set to null in the
 * shared memory case.
 *=======================================================================*/

#define INCR_BY_STRING_MSGSIZE(s)

#define INCR_BY_SIZE(b)

#define INCR_BY_SIZE_IF_FUTURES(b)

#define SEND_MSG_SIZE()

#endif /* _CORE_SHM_H */
