#include "core_veneer.h"
#include "th_interface.h"

bool th_init() {
  char *fe, *fe_flags, *fe_location;

  th_init_config();

  fe = getenv("FE_PROGRAM");
  fe_flags = getenv("FE_FLAGS");
  fe_location = getenv("FE_LOCATION");

  if (fe) 
    sprintf(th_config->fe_cmd, "%s", fe);

  if (!fe_flags) fe_flags = "";

  if (!_th_open_frontend(fe_location, fe_flags))
    return FALSE;

  /* Lookup the wellknown interface object "Iobj" to make various
     calls on */
  th_config->iobj = _th_lookup_wellknown("Iobj");

  if(th_config->iobj)
    return TRUE;
  else
    return FALSE;
}

bool th_invoke(core_value self, th_handle method_handle, 
	       core_value *args, int argc, core_value *result) {
  int i;
  bool res;

  RETURN_ZERO_INT_IF_EXC();

  for (i = 0; i < argc; i++) {
    INCR_BY_SIZE(_th_sizeof_core_value(args[i]));
  }

  th_begin_invoke(self, method_handle, FALSE, FALSE);

  for (i = 0; i < argc; i++) {
    _th_put_core_value(args[i]);
  }

  res = th_do_invoke();

  if (res && result) {
    _th_get_core_value(result);
  }

  th_end_invoke();

  return res;
}

th_handle th_get_root() {
  return _th_lookup_wellknown("root");
}

void th_shutdown() {
  bool ok;

  CLEAR_ALL_EXC();

  th_assert(th_config->iobj, "Invalid interface object\n");

  ok = th_interface_close(th_config->iobj,
			     th_config->fe_state == fe_slave);

  th_assert(ok, "Shutdown operation failed\n");

  if (_th_fclose(th_config->client_in)==0 &&
      _th_fclose(th_config->client_out)==0) {
    th_config->fe_state = fe_closed;
  }
}

/*=========================================================================
 *  Transactions
 *========================================================================*/

void th_commit() {

  if (ANY_UNHANDLED_EXC()) {
    if (UNHANDLED_EXC(ABORT_EXC_NAME))
      /* abort has already been raised */
      return;

    /* else, client did not handle last exception */
    _th_unhandled_exc(th_config->exc);
  }

  th_interface_commit(th_config->iobj);  /* XXX ignore result? */

}

void th_abort() {
  char *excname;

  while (TRUE) {
    th_interface_abort(th_config->iobj);

    if (!th_catch_any(&excname))
      break;
    /* Some exception could have been raised. Try the abort again
       Multiple aborts are idempotent */
  }

  /*  RESET_EXC(); */
}

/*------------------- Support for basic types ----------------------------*/

th_handle th_int_to_any(int i) {
    th_handle result = th_interface_int_to_any(th_config->iobj, i);
    return result;
}

th_handle th_char_to_any(char c) {
    th_handle result = th_interface_char_to_any(th_config->iobj, c);
    return result;
}

th_handle th_bool_to_any(bool b) {
    th_handle result = th_interface_bool_to_any(th_config->iobj, b);
    return result;
}

/*
th_handle th_null_to_any(null n) {
    th_handle result = th_interface_null_to_any(th_config->iobj, 0);
    return result;
}
*/

int th_force_to_int(th_handle a) {
    int result = th_interface_force_to_int(th_config->iobj, a);
    return result;
}

char th_force_to_char(th_handle a) {
    char result = th_interface_force_to_char(th_config->iobj, a);
    return result;
}

bool th_force_to_bool(th_handle a) {
    bool result = th_interface_force_to_bool(th_config->iobj, a);
    return result;
}

/*
null th_force_to_null(th_handle a) {
    null result = (null)th_interface_force_to_null(th_config->iobj, a);
    return result;
}
*/

th_handle th_chars_to_string(char const* s) {
  th_handle a;

  RETURN_INVALID_HANDLE_IF_EXC();

  INCR_BY_STRING_MSGSIZE(s);
  SEND_MSG_SIZE();
  _th_put_input(th_config->client_out);
  _th_put_string(s);
  if (_th_get_fe_response()) {
    return _th_new_handle();
  } else {
    return 0;
  }
}

char* th_string_to_chars(th_handle s) {

  static char buf[1024];     /* XXX */

  RETURN_EMPTY_STRING_IF_EXC();

  INCR_BY_SIZE(sizeof(th_handle));
  SEND_MSG_SIZE();
  _th_put_print(th_config->client_out);
  _th_put_handle(s);
  if (_th_get_fe_response()) {
    _th_get_string(buf, 1024);
    return buf;
  }
  return "";
}

bool th_catch(char *name) {
  _th_check_for_exception_at_fe();
  if (UNHANDLED_EXC(name)) {
    RESET_EXC();
    return TRUE;
  }
  return FALSE;
}

bool th_catch_any(char** name) {
  _th_check_for_exception_at_fe();
  if (ANY_UNHANDLED_EXC()) {
    strcpy(th_config->exception_copy, th_config->exc);
    *name = th_config->exception_copy;
    RESET_EXC();
    return TRUE;
  }
  return FALSE;
}
