;;; Given a Thor list starting at "handle", cdr-down returns an Emacs list
;;; of the data in that list.

(require 'ascii-fe)

(defun cdr-down (handle)
  (condition-case except
      (let ((this-car (afe-invoke handle "first"))
	    (this-cdr (afe-invoke handle "rest")))
	(cons this-car (cdr-down this-cdr)))
    (afe-exception (let ((data (cdr except)))
		     (if (string= data "empty")
			 nil
		       (signal afe-exception data))))))
	