(require 'ascii-fe)

(defun oo7-client-print-atomic (handle)
  ;; Show the data fields for this atomic obj.
  (let* ((id (thor-car handle))
	 (pre-x (thor-cdr handle))
	 (x (thor-car pre-x))
	 (pre-y (thor-cdr pre-x))
	 (y (thor-car pre-y))
	 (pre-date (thor-cdr pre-y))
	 (date (thor-car pre-date))
	 (pre-to (thor-cdr pre-date))
	 (pre-from (thor-cdr pre-to))
	 (pre-parent (thor-cdr pre-from))
	 (parent-id (thor-car (thor-car pre-parent))))  ; should be end of list
    (concat "id:   " id "\n"
	    "x:    " x "\n"
	    "y:    " y "\n"
	    "date: " date "\n"
	    "pid:  " parent-id "\n")))

(defun oo7-client-outgoing-list (handle)  
  (thor-nth handle 4))

(defun oo7-client-incoming-list (handle)
  (thor-nth handle 5))

(defun oo7-client-print-composite (handle)
  (let* ((id (thor-car handle))
	 (atomroot (thor-car (thor-cdr handle))))
    (concat "Composite id: " id "\n"
	    (oo7-client-traverse-atoms atomroot))))

(defun oo7-client-traverse-atoms (h)
  ;; Just do the root for now
  (let ((to (oo7-client-outgoing-list h))
	(from (oo7-client-incoming-list h))
	(vars (oo7-client-print-atomic h)))
    (concat "\n" vars
	    "\n To: " (thor-mapconcat 'oo7-client-print-id to " ") 
	    "\n From: " (thor-mapconcat 'oo7-client-print-id from " ")
	    "\n-------------------------\n")))

(defun oo7-client-print-id (h)
  (thor-car h))

(provide 'oo7-client)