(require 'ascii-fe)

;; This is a very expensive implementation.  We need to develop a 
;; better way of doing this.
(defun thor-empty (h)
  (string= (afe-wellknown "emptyList") (afe-invoke h "getClass")))

(defun thor-car (h)
  (afe-invoke h "first"))

(defun thor-cdr (h)
  (afe-invoke h "rest"))

(defun thor-nth (h n)
  (let ((i 0)
	(curr h))
    (while (< i n)
      (progn
	(setq i (+ i 1))
	(setq curr (thor-cdr curr))))
    (thor-car curr)))
    
(defun thor-show-list (h)
  (if (thor-empty h)
      ""
    (concat (thor-car h) " " (thor-show-list (thor-cdr h)))))

(defun thor-map (func h)
  (if (thor-empty h)
      nil
    (cons 
     (funcall func (thor-car h)) 
     (thor-map func (thor-cdr h)))))

(defun thor-mapconcat (func h sep)
  (if (thor-empty h)
      ""
    (concat 
     (funcall func (thor-car h)) 
     sep 
     (thor-mapconcat func (thor-cdr h) sep))))


;;; XXX should have constructors, etc.

(provide 'thor-lists)