MODULE Test EXPORTS Main;

IMPORT Env, Stdio, Wr, 
       Thor, Veneer, Thor_any, Thor_list;

(* This will open a socket to the FE.  The FE's location is in the 
   environment variable FE as host:port  
   
   It will pick localhost:2222 as a default.  *)


CONST
  DefaultHost = "localhost:2222";

VAR
  root: Thor_any.T;

PROCEDURE FindFE():TEXT =
  VAR
    Envr:TEXT := Env.Get("FE");
  BEGIN
    IF (NIL # Envr) THEN
      RETURN Envr
    ELSE
      Wr.PutText (Stdio.stderr,"Environment var FE not set. Using default.\n");
      RETURN DefaultHost
    END
  END FindFE;

BEGIN
    Veneer.OpenFE(FindFE());
    Wr.PutText(Stdio.stderr,"Connected to FE\n");
    root := Veneer.WellKnown("root");
    Wr.PutText(Stdio.stderr,"Got root object\n");
END Test.
