MODULE Network;

IMPORT TCP, IP, ConnRW;


REVEAL T = Public BRANDED OBJECT
  tcp: TCP.T;
END;

PROCEDURE Connect (host: TEXT; port: INTEGER): T 
    RAISES {Error} =
  VAR n := NEW (T);
      addr: IP.Address;
      endpoint: IP.Endpoint;  
  BEGIN
    TRY
      IF NOT IP.GetHostByName(host, addr) THEN
        RAISE Error("Could not find host")
      END;
      endpoint := IP.Endpoint{addr := addr, port := port};
      n.tcp := TCP.Connect(endpoint);
      n.rd := ConnRW.NewRd(n.tcp);
      n.wr := ConnRW.NewWr(n.tcp);
      RETURN n;
    EXCEPT
      IP.Error => RAISE Error("Could not connect to FE")
    END;
  END Connect;

BEGIN
END Network.
