INTERFACE Veneer;

(*

The following commands are supported in ASCII mode
  help, ? : This message
  quit, q : Close connection
  shutdown : shut down FE
  invoke <self> [<type>.]<method> <arg1> .. <argn> : evaluate an expr
  input  <string> : return a handle to <string>
  wellknown <objname> : supply handle for object `objname'
  print <object> : display the given object of a builtin type
  stringlen <integer> : set the maximum length of strings to display directly
  binary : Enter binary mode
  checkpoint, cp : commit changes, start a new transaction
  abort : abort current transaction

  Multiple commands may be separated by semicolons.

  No other help available yet.

*)

FROM Thor IMPORT Failure, Except;
IMPORT Thor;
FROM Thread IMPORT Alerted;

PROCEDURE OpenFE(fe: TEXT) RAISES {Failure, Alerted};

PROCEDURE CloseFE() RAISES {Failure, Alerted};

PROCEDURE Lock();

PROCEDURE Unlock();

PROCEDURE WellKnown(wk: TEXT): Thor.any RAISES {Failure, Alerted};

PROCEDURE Commit() RAISES{Failure, Alerted, Except};

PROCEDURE Abort() RAISES {Failure, Alerted};

PROCEDURE HandleToObj(h: INTEGER): Thor.any RAISES {Failure};

PROCEDURE InstallObj(h: INTEGER; th: Thor.any) RAISES {Failure, Alerted};

PROCEDURE BeginInvoke(h: INTEGER; meth: TEXT;<*UNUSED*>deferp: BOOLEAN) 
          RAISES {Failure, Alerted};

PROCEDURE DoInvoke( <* UNUSED *> deferp: BOOLEAN) 
                   RAISES {Except, Failure, Alerted};

PROCEDURE EndInvoke(<*UNUSED*>deferp: BOOLEAN) 
                    RAISES {Failure, Alerted};

PROCEDURE PutHandle(h: INTEGER) RAISES{Failure, Alerted};

PROCEDURE GetHandle(): INTEGER RAISES{Failure, Alerted};

PROCEDURE PutInt(i: INTEGER) RAISES{Failure, Alerted};

PROCEDURE GetInt(): INTEGER RAISES{Failure, Alerted};

PROCEDURE PutNull(n: NULL) RAISES{Failure, Alerted};

PROCEDURE GetNull(): NULL RAISES{Failure, Alerted};

PROCEDURE PutChar(c: CHAR) RAISES{Failure, Alerted};

PROCEDURE GetChar(): CHAR RAISES{Failure, Alerted};

PROCEDURE PutReal(f: REAL) RAISES{Failure, Alerted};

PROCEDURE GetReal(): REAL RAISES{Failure, Alerted};

PROCEDURE PutBool(b: BOOLEAN) RAISES{Failure, Alerted};

PROCEDURE GetBool(): BOOLEAN RAISES{Failure, Alerted};

PROCEDURE PutString(t: TEXT) RAISES {Failure, Alerted};

PROCEDURE GetString(): TEXT RAISES{Failure, Alerted};

END Veneer.





