#!./browse

source thor.tcl

set module [thor-wellknown root]

set ra [thor $module designRoot]

set CAClass [thor-wellknown ComplexAssembly]
set BAClass [thor-wellknown BaseAssembly]

proc DoTraverse {ca} {
  puts stdout "Assembly $ca"
  flush stdout
  global CAClass BAClass
  set class [thor $ca getClass]
  if {$class == $CAClass} {
    set numa [thor $ca numAssemblies]
    for {set i 0} {$i < $numa} {incr i} {
      DoTraverse [thor $ca assemblyIndex $i]
    }
  } else {
    if {$class == $BAClass} {
      set numc [thor $ca numComponentsPriv]
      for {set i 0} {$i < $numc} {incr i} {
        DoCompositeTraverse [thor $ca componentsPrivIndex $i]
      }
    } else {
      error "Unexpected class $class"
    }
  }
}

proc DoCompositeTraverse {comp} {
  puts stdout "CompositePart $comp"
  flush stdout
  global PartsVisited
  set rt [thor $comp rootPart]
  set queue {}
  lappend queue $rt
  set qindex 0
  while {$qindex < [llength $queue]} {
    set curr [lindex $queue $qindex]
    if {[catch {set marked($curr)}]} {
      set marked($curr) 1
      incr PartsVisited
      set numc [thor $curr numOutgoing]
      for {set i 0} {$i < $numc} {incr i} {
        set conn [thor $curr outgoingIndex $i]
        set part [thor $conn to]
        lappend queue $part
      }
    }
    incr qindex
    set len [llength $queue]
    if {0} {
      puts stdout "qlength = $len, qindex = $qindex"
      flush stdout
    }
  }
  puts stdout "Visited $PartsVisited parts so far"
  flush stdout
}

set PartsVisited 0

DoTraverse $ra

