/* Selective monitoring of code */

#ifndef _MONITOR_H
#define _MONITOR_H

#ifdef __cplusplus
extern "C" {
#endif


#include<sys/types.h>

extern unsigned long _ftext;
extern unsigned long _etext;
extern int monitor(
          caddr_t lowpc,
          caddr_t highpc,
          char * buffer,
          size_t bufsiz,
          size_t nfunc);

extern  int monstartup(
          caddr_t lowpc,
          caddr_t highpc);

extern  int moncontrol(
          int mode);


extern void start_monitor();
    /* To start monitoring for the first time.
       Requires that the program is not linked with -p, 
       in which case monitoring begins automatically before main().
       */
    /* XXX Currently, monstartup does not work as specified in man page.
       Until it is fixed, link with -p, stop_monitor in main, 
       then resume_monitor at the place you want monitoring to start.
       */
    
extern void stop_monitor();
    /* To stop monitoring after it has been started by using -p at
       link time or through start_ or resume_monitor. */


extern void resume_monitor();
    /* To resume monitoring after it has been stopped by stop_monitor. */

extern void output_monitor();
    /* To write out "mon.out" containing monitoring data.
       If this is not called, the file will be  written out 
       at the end of the program. */

#ifdef __cplusplus
}
#endif

#endif  /* _MONITOR_H */
