/*
\section{Bit-Fields of various Sizes}

This file contains definitions of bitfields of various sizes.  The
definitions vary by compiler and architectures.  The unsigned types
defined here are "ubits16", "ubits32", and "ubits64".  The signed
types defined here are "bits16", and "bits32".  Arithmetic is not
guaranteed to work on "ubits64".  Therefore you should not perform
arithmetic operations on "ubits64" values.  In addition, unsigned
arithmetic can lead to unexpected results so avoid arithmetic on
"ubits16" and "ubits32" values as well.
*/

#ifndef _BITS_H
#define _BITS_H

#define byte_bits 8

#ifdef __alpha

typedef unsigned short ubits16;
typedef unsigned int   ubits32;
typedef unsigned long  ubits64;

typedef short bits16;
typedef int   bits32;

#define LONG_SIGN_BIT_MASK 0x8000000000000000UL
#define INT_SIGN_BIT_MASK 0x80000000UL

#define _BITS_H_OK
#endif


#ifdef mips

typedef unsigned short ubits16;
typedef unsigned long  ubits32;
typedef struct { ubits32 low; ubits32 high; } ubits64;

typedef short bits16;
typedef int   bits32;

#define LONG_SIGN_BIT_MASK 0x80000000UL
#define INT_SIGN_BIT_MASK 0x80000000UL

/* XXX _Will we ultimately want an R4000 variant of "bits64"?_ */

#define _BITS_H_OK
#endif

#ifndef _BITS_H_OK
#error "bits.h" does not know about this machine architecture.
#endif
#undef _BITS_H_OK

#endif
