#ifndef _BUCKETS_H
#define _BUCKETS_H

#define BK_TEMPLATE template <class KEY, class VALUE>

BK_TEMPLATE struct BucketsImpl;
BK_TEMPLATE class BucketsGenerator;

BK_TEMPLATE class Buckets {
public:
/*
    A "Buckets" is a standard implementation of a PAIRSET (see "map.h")
    using a linked list of buckets. It is suitable for use with a "BHash",
    e.g.

    "BHash<IntKey, char, Buckets<IntKey, char>, Buckets<IntKey, char>::Generator>"

    is a well-defined type since "IntKey" satisfies both the KEY and VALUE
    constraints.
*/
    Buckets();
    ~Buckets();
    Buckets(Buckets<KEY, VALUE> const &);
    void operator=(Buckets<KEY, VALUE> const &);
    bool find(KEY, VALUE &) const;
    VALUE fetch(KEY) const;
    void add(KEY, VALUE);
    bool store(KEY, VALUE);
    bool remove(KEY, VALUE &);
    VALUE remove_fast(KEY);
    void clear_mappings(void);
    HashGenerator<KEY, VALUE> *mappings();

protected:
    friend class BucketsGenerator<KEY, VALUE>;

    bool find_loop(KEY, VALUE &, BucketsImpl<KEY, VALUE> *) const;

    BucketsImpl<KEY, VALUE> *pairs;
#ifdef __GNUC__
    static BucketsGenerator<KEY, VALUE> *dummy; // force g++ expansion
    // this previous line actually makes cxx screw up for some reason
#endif
};

#endif /* _BUCKETS_H */
