/*
\section{Buffered Network Interface}

This class behaves like a Network, except that it uses a read
buffer in an attempt to reduce the number of system calls.

\subsection{Todo}
\begin{itemize}
\item Introduce write buffering as well?
\item Generalize to provide buffering for any FDevice?
\end{itemize}
*/

#ifndef _BUFNET_H
#define _BUFNET_H

#include "network.h"

class BufNetwork : public Network {
  public:
    BufNetwork(int s, int bufsize);
    virtual ~BufNetwork();

    virtual bool can_read();
    virtual bool has_buffered_data();
  protected:
    virtual bool read_bytes(void* ptr, int size);
    virtual bool read_vector(struct iovec* vec, int count);

    char* buf;		// Buffer
    char* bufend;	// Ptr past end of buffer
    char* current;	// Current pointer into buffer
    int   bufsize;	// Total buffer size
};

#endif /* _BUFNET_H */
