#include <errno.h>
#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>
#include "compat.h"

#ifndef HAVE_GETCLOCK

/* Provide getclock() emulation */

int getclock(int clk, struct timespec* sp) {
    struct timeval tv;

    if (clk != TIMEOFDAY) {
	errno = EINVAL;
	return -1;
    }

    if (gettimeofday(&tv, 0) < 0) {
	return -1;
    }

    sp->tv_sec = tv.tv_sec;
    sp->tv_nsec = tv.tv_usec * 1000;
    return 0;
}

#endif
