#include "fe_num.h"
#include "device.h"
#include "unparser.h"
#include "config/vdefs/COMPILER.h"

fe_num::fe_num(ubits32 a, ubits32 b, ubits32 c, ubits32 d) {
    id[0] = a;
    id[1] = b;
    id[2] = c;
    id[3] = d;
}

void fe_num::operator=(fe_num const& f) {
    id[0] = f.id[0];
    id[1] = f.id[1];
    id[2] = f.id[2];
    id[3] = f.id[3];
}

bool fe_num::operator<(fe_num const& f)  const {
    if (id[0] != f.id[0])
	return (id[0] < f.id[0]);
    if (id[1] != f.id[1])
	return (id[1] < f.id[1]);
    if (id[2] != f.id[2])
	return (id[2] < f.id[2]);
    return (id[3] < f.id[3]);
}

bool fe_num::operator>(fe_num const& f)  const {
    return ! (*this < f || *this == f);
} 

bool fe_num::encode(Device* dev) const {
    return (dev->send_buffer(this, sizeof(fe_num)));
}

bool fe_num::decode(Device* dev) {
    return (dev->recv_buffer(this, sizeof(fe_num)));
}

void fe_num::unparse(unparser *unp) {
#if !COMPILER
    unp->print("FE id = (%u, %u, %u, %u)", id[0], id[1], id[2], id[3]);
    unp->newline();
#endif
}
