/*
\section{FE Identifier Format}

FE numbers are assumed to be unique; they used are in timestamps to break ties.

This is a stack abstraction!!
*/

#ifndef _FE_NUM_H
#define _FE_NUM_H

#include "common/basic.h"
#include "common/bits.h"

class Device;
class unparser;

class fe_num {
  public:
    fe_num();
    // effects - Uninitialized fe number

    fe_num(ubits32, ubits32, ubits32, ubits32);
    // effects - fe_num initialized with the supplied values.

    ~fe_num();

    void operator=(fe_num const& f);
    // Assignment operator

    bool operator==(fe_num const& f)  const;
    // effects --- returns true iff this "=" f.

    bool operator<(fe_num const& f)  const;
    // effects --- returns true iff this "<" f.

    bool operator>(fe_num const& f)  const;
    // effects --- returns true iff this ">" f.
    
    bool encode(Device*) const;
    bool decode(Device*);

    void unparse(unparser *unp);

  private:
    ubits32 id[4];
};

/* Trivial routines. */

inline fe_num::fe_num() {
}

inline fe_num::~fe_num() {
}

inline bool fe_num::operator==(fe_num const& f)  const {
    // Using & instead of && to avoid excessive jumps
    return (id[0] == f.id[0] & id[1] == f.id[1] & id[2] == f.id[2] &
	    id[3] == f.id[3]);
}

#endif /* _FE_NUM_H */
