// \section{Unique Timestamp}

#include "common/basic.h"
#include "common/device.h"
#include "common/fe_num.h"
#include "common/unparser.h"

#include "global_tstamp.h"

Global_Tstamp::Global_Tstamp() {
}


Global_Tstamp::Global_Tstamp(fe_num fenum, Tstamp const& localt):
    ltime(localt)
{
    FE_id = fenum;
}

Global_Tstamp::Global_Tstamp(Global_Tstamp const& t): ltime(t.ltime) {
    FE_id = t.FE_id;
}

void Global_Tstamp::operator=(Global_Tstamp const& t) {
    FE_id = t.FE_id;
    ltime = t.ltime;
}

bool Global_Tstamp::operator<(Global_Tstamp const& t)  const{
    if (ltime != t.ltime)
	return (ltime < t.ltime);
    return (FE_id < t.FE_id);
}
    
bool Global_Tstamp::operator==(Global_Tstamp const& t)  const{
    return (ltime == t.ltime && FE_id == t.FE_id);
}

bool Global_Tstamp::operator>(Global_Tstamp const& t) const {
    if (ltime != t.ltime)
	return (ltime > t.ltime);
    return (FE_id > t.FE_id);
}

Global_Tstamp Global_Tstamp::operator+(bits32 increment) const {
    return ( Global_Tstamp (FE_id, ltime + increment));
}

Global_Tstamp Global_Tstamp::max (Global_Tstamp& t) const {
    return( (*this < t) ? t: *this);
}

bool Global_Tstamp::encode(Device* dev) const {
    return (ltime.encode(dev) && FE_id.encode(dev));
}

bool Global_Tstamp::decode(Device* dev) {
    return (ltime.decode(dev) && FE_id.decode(dev));
}

void Global_Tstamp::unparse (unparser* unp) {
    unp->print("Gts: ");
    unp->indent(3);
    FE_id.unparse(unp);
    ltime.unparse(unp);
    unp->indent(-3);
    unp->newline();
}
