/*
\section{Unique Timestamp}

This file implements a unique timestamp.
It is a stack abstraction so that we can overload the usual arithmetic
operations to work with timestamps.
*/

#ifndef _GLOBAL_TSTAMP_H
#define _GLOBAL_TSTAMP_H

#include "common/basic.h"
#include "common/bits.h"
#include "common/fe_num.h"
#include "common/tstamp.h"

class fe_num;
class unparser;
class Device;

class Global_Tstamp {
  public:
    Global_Tstamp();
    // effects - Uninitialized timestamp.

    Global_Tstamp(fe_num fenum, Tstamp const& t);
    // effects - makes an object that is a global timestamp using the
    // the FE_id fenum and the local timestamp t.

    Global_Tstamp(Global_Tstamp const&);
    // Copy Constructor.
    
    void operator=(Global_Tstamp const& t);
    // Assignment operator.

    bool operator<(Global_Tstamp const& t)  const;
    // effects --- returns true iff this "<" t.
    
    bool operator==(Global_Tstamp const& t)  const;
    // effects --- returns true iff this "==" t.
    
    bool operator>(Global_Tstamp const& t) const;
    // effects --- returns true iff this ">" t.

    Global_Tstamp operator+(bits32 increment) const;
    // effects --- incrments the timestamp by "increment" microseconds.

    Global_Tstamp max (Global_Tstamp& t) const;
    // effects --- returns max (this, t)
    
    bool same_source(Global_Tstamp& t) const;
    // effects -- Returns TRUE if this and t were generated by the same source

    bool encode(Device*) const;
    bool decode(Device*);

    void unparse (unparser* unp);

  private:
    // Representation. 
    fe_num FE_id;        // Unique FE number.  Must have <, >, == ops.
    Tstamp ltime;        // Local times.
};

inline bool Global_Tstamp::same_source(Global_Tstamp& t) const {
    return FE_id == t.FE_id;
}

#endif /* _GLOBAL_TSTAMP_H */
