#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "hostname.h"
#include "other_unix.h"

#ifndef __alpha
/* Ultrix has no prototype for sscanf */
extern int sscanf(char const*, char const*, ...);
#endif

#include <stdio.h>

bool findhost(char const* hostname, struct in_addr* address) {
    struct hostent* h;
    int a, b, c, d;

    if (strcmp(hostname, "") == 0) {
	address->s_addr = INADDR_ANY;
	return TRUE;
    }

    h = gethostbyname(hostname);
    if (h != 0) {
	memcpy(address, h->h_addr, h->h_length);
	return TRUE;
    }

    if (sscanf(hostname, "%d.%d.%d.%d", &a, &b, &c, &d) == 4) {
	/* Numerical internet-address */
	unsigned long hostaddr = (a<<24)|(b<<16)|(c<<8)|d;
	address->s_addr = htonl(hostaddr);
	return TRUE;
    }

    return FALSE;
}

bool findport(char const* spec, int base, struct sockaddr_in* address) {
    char *sep;
    char *scanned;
    char *host;
    long port;

    sep = strrchr(spec, ':');
    if (sep == 0) {
	return FALSE;
    }

    port = strtol(sep+1, &scanned, 10);
    if (scanned == sep+1) {
	return FALSE;
    }

    host = (char*) malloc((sep - spec + 1) * sizeof(char));
    strncpy(host, spec, sep - spec);
    host[sep - spec] = '\0';
    if (! findhost(host, &(address->sin_addr))) {
	free(host);
	return FALSE;
    }
    free(host);

    address->sin_port = htons(base + port);
    address->sin_family = AF_INET;
    return TRUE;
}

