/* \section{Interface for Host-Name Parsers} */

#ifndef _HOSTNAME_H
#define _HOSTNAME_H

#ifdef __cplusplus
extern "C" {
#endif

#include "common/basic.h"
#include "common/other_unix.h"

extern bool findhost(char const* hostname, struct in_addr* address);
    /*
     * modifies - *address
     * effects  - If spec is a valid hostname set address to its address
     *	          and return TRUE.  Else if spec is "", set address to
     *		  INADDR_ANY and return TRUE.  Else return FALSE.
     */

extern bool findport(char const* spec, int base, struct sockaddr_in* address);
    /*
     * modifies - *address
     * effects  - If spec is a string of the form "[<machine>]:<number>", then
     *		  post(address->sin_family) == AF_INET.
     *		  post(address->sin_port) = <number> + base.
     *		  post(address->sin_addr) = address(<machine>).
     *		  (if <machine> is ommitted, use INADDR_ANY for address)
     *		  Returns true.
     *	          Else returns false.
     */

#ifdef __cplusplus
}
#endif

#endif /* _HOSTNAME_H */
