#ifndef _HT_PRIV_H
#define _HT_PRIV_H

// Private routines for hash table code

// effects  Return secondary hash value for "v"
extern int htable_hash2(int v);

// Constants to fix up the hash value to the right range
static const int htable_precbits = (sizeof(int) << 3) - 2;
static const int htable_precmask = (1 << htable_precbits) - 1;

// effects  Convert an integer into a primary hash value
inline int htable_int_hash(int value) {
    return (int) ((((unsigned int) value) * 1737350766) & htable_precmask);
}

inline int htable_fix_hash(int value, int n) {
    return (value >> (htable_precbits - n));
}

// Default maximum occupancy of hash table in percent.
// If the table becomes more than this full, it is enlarged.
static const int htable_default_max_occupancy = 80;

// Divisor to obtain minimum occupancy from maximum occupancy.
// We set this to four so that the table does not keep bouncing
// back and forth between two contiguous sizes as a small number
// of elements are inserted and removed.
static const int htable_min_occupancy_divisor = 4;

// Collision count stats are only kept if assertion checking is on.
// All code that is stats related should be enclosed in "HTABLE_STAT"
// as follows:
//		HTABLE_STAT(collissions++);
#ifdef NDEBUG
#define HTABLE_STAT(x) 0
#else
#define HTABLE_STAT(x) x
#endif

#endif /* _HT_PRIV_H */
