/*
    Intentionally not protected by #ifndef's! Define IMPL_KEY and IMPL_VALUE
    immediately before including this file. It removes the mappings for IMPL_KEY
    and IMPL_VALUE, so that they behave like arguments to the file.
*/

/*
    This file instantiates the class "Map<IMPL_KEY, IMPL_VALUE>". It should
    only be included once per distinct KEY/VALUE combination.

    Note that if the key is a primitive value (e.g. int) or a pointer, you
    will want to define KEY to be something like "IntKey" or "PtrKey<T>".
    See "common/map.h" for more details.

    For example, a map from integers to void *:

#define IMPL_KEY IntKey
#define IMPL_VALUE void *
#include "common/impl_map.t"

    This implements the type "Map<IntKey, void *>". Users of this
    type need only include "common/map.h"
*/

#include "common/bhash.t"
#include "common/buckets.t"

#ifdef __DECCXX
#pragma define_template Map<IMPL_KEY, IMPL_VALUE>
#pragma define_template Buckets<IMPL_KEY, IMPL_VALUE>
#pragma define_template BHash<IMPL_KEY, IMPL_VALUE, \
                              Buckets<IMPL_KEY, IMPL_VALUE> >
#pragma define_template BucketsImpl<IMPL_KEY, IMPL_VALUE>
#pragma define_template BHashGenerator<IMPL_KEY, IMPL_VALUE, \
                                       Buckets<IMPL_KEY, IMPL_VALUE> >
#pragma define_template BucketsGenerator<IMPL_KEY, IMPL_VALUE>
#endif

#ifdef __GNUC__
class Map<IMPL_KEY, IMPL_VALUE>;
#endif

#undef IMPL_KEY
#undef IMPL_VALUE
