#include "common/mos.h"
#include "common/device.h"
#include "common/unparser.h"

Mos::Mos() : Modset() {
    objrefs = new orefs;
}

Mos::~Mos(){
    delete objrefs;
}

Obj_Handle Mos::add_object(Oref oref, int no_fields) {
    objrefs->append(oref);
    return Modset::add_object(no_fields);
}

void Mos::clear() {
    objrefs->clear();
    Modset::clear();
}

int Mos::rep_size() const {
    return (Modset::rep_size() + sizeof(Oref) * count());
}

bool Mos::encode(Device* dev) const {
    // First encode the "Modset" part and then encode the orefs.
    return (Modset::encode(dev) &&
	    dev->send_buffer(objrefs->as_pointer(), sizeof(Oref) * count()));
}

bool Mos::decode(Device* dev) {
    // First decode the "Modset" part and then decode the orefs.
    if (! Modset::decode(dev)) return FALSE;

    // Enlarge the oref array to the right size
    objrefs->clear();
    objrefs->_enlarge_by(count());
    return (dev->recv_buffer(objrefs->as_pointer(), sizeof(Oref) * count()));
}

void Mos::unparse(unparser* unp) {
    unp->print("Mos: Msize=%d\n", count());

    unp->indent(4);
    Modset::unparse(unp);
    // Unparse the orefs
    for (int i = 0; i< objrefs->size(); i++) {
	Oref oref = objrefs->slot(i);
	unp->print("Oref = %d:%-d \n",OREF_SEGMENT(oref),OREF_INDEX(oref));
    }
    unp->indent(-4);
}
