/*
\section{Network Interface}

This is an interface to a device built on a TCP/IP stream.
*/

#ifndef _NETWORK_H
#define _NETWORK_H

#include "fdevice.h"
class NetworkSet;

class Network : public FDevice {
  public:
    Network(int sock);
    // requires - sock is a connect TCP socket.
    // effects  - Create a transmission channel for the connection
    //		  inherent in sock.

    virtual ~Network();
    // effects  - Closes the transmission channel and the underlying
    //		  TCP connection/socket.

    void set_nodelay();
    // modifies - this
    // effects - set underlying net connection to send packets quickly 
    //           instead of waiting for packet to fill.  Only needs to
    //           be called once for the lifetime of the connection.

    void set_buffsizes();
    // modifies - this
    // effects - set underlying net connection's buffer sizes.
    //           Only needs to be called once for the lifetime of the 
    //           connection.

    void allow_sigio();
    // effects: Allow SIGIO to be delivered to the process whenever
    //          a message is received on this connection

    virtual bool can_read();
    // effects	Returns true iff data is available for reading without
    //		blocking.

    virtual bool has_buffered_data();
    // effects	returns TRUE iff there is data buffered on the connection
    //          (in this abstraction's internal state)

    bool sloppy_read_bytes(void* ptr, int size, int* count);
    // XXX This doesn't belong here!  Need to rethink this
    //     interface for better performance at the FE.
    // effects - reads up to size bytes from network into buffer 
    //           pointed to by ptr.  Mutates count to be the actual
    //           number of bytes read.  Returns TRUE if all is well,
    //           FALSE otherwise.

    int wait_or_timeout(int msec);
    // effects Waits on the network connection until there is some input or
    //         it times out after msec milliseconds. Returns 0 if it times
    //         out, 1 if there is some input on the connection. If there is
    //         a connection error returns -1

  private:
    friend NetworkSet;  // NetworkSet should only use the following method

    int get_descriptor();
    // effects Returns file descriptor associated with this

}; 

#endif /* _NETWORK_H */
