#include <errno.h>
#include "openhashmap.h"
#include "intarray.h"
#include "or_num.h"
#include "network.h"
#include "networkset.h"

// XXX We are currently using Or numbers hashing functions for this class.
// We maywant to change this later
declareOpenHashMap(NetworkTab, OR_num, Network*, ORNUM_HASH, ORNUM_EQUAL) 
implementOpenHashMap(NetworkTab, OR_num, Network*, ORNUM_HASH, ORNUM_EQUAL) 

extern int errno;

NetworkSet::NetworkSet() {
    tab = new NetworkTab(1);
    maxfd = 0;
    keymap = new IntArray;
    result_keys = new IntArray;
}

NetworkSet::~NetworkSet() {
    delete tab;
    delete keymap;
    delete result_keys;
}

void NetworkSet::add(int key, Network* net) {
    tab->store(key, net);
    int fd = net->get_descriptor();
    FD_SET(fd, &fds);

    if (fd > maxfd) maxfd = fd;
    if (fd > keymap->size())
	keymap->append(-1, fd + 1 - keymap->size());
    keymap->slot(fd) = key;
}

Network* NetworkSet::fetch(int key) const {
    Network* net = NULL;
    tab->fetch(key, net);
    return net;
}

Network* NetworkSet::remove(int key) {
    Network* net;
    bool found = tab->fetch(key, net);
    if (!found) return NULL;
    tab->remove(key);
    int fd = net->get_descriptor();
    FD_SET(fd, &fds);
    keymap->slot(fd) = -1;
    // We are not currently decreasing the value of maxfd
    return net;
}

int NetworkSet::readselect(int timeout, IntArray*& result) {

    struct timeval tmval, *tmvalp;
    tmval.tv_sec =  timeout / 1000000;
    tmval.tv_usec = timeout % 1000000;
    tmvalp = (timeout < 0) ? NULL: &tmval;

    result_keys->clear();
    result = result_keys;
    bool* havedata = new bool[maxfd+1];
    for (int fd = 0; fd <= maxfd; fd++) havedata[fd] = FALSE;
	
    fd_set tmpfds;
    while (1) {
	// First check whether data can be read from each network
	// We do that using "can_read" since in a buffered network the
	// data may already have been read
	
	for (NetworkTab::Bindings gen(tab); gen.ok(); gen.next()) {
	    Network *net = gen.val();
	    fd = net->get_descriptor();
	    havedata[fd] = havedata[fd] || net->has_buffered_data();
	}
	// Now try the select call
	memcpy(&tmpfds, &fds, sizeof(fds));
	int retval = select (maxfd+1, &tmpfds, NULL, NULL, tmvalp);
	if (retval < 0 && errno == EINTR) continue; // signal received
	if (retval <= 0) return retval;
	break;
    }

    // Check which networks have the data
    for (fd = 0; fd < maxfd+1; fd++) {
	if (FD_ISSET(fd, &tmpfds) || havedata[fd]) {
	    int key = keymap->slot(fd);
	    result->append(key);
	}
    }

    delete havedata;
    th_assert(result->size() > 0, "Number of networks on which data is"
	      "present should be more than 0");
    return result->size();
}
